// Copyright ® 2025 OneSpan North America, Inc. All rights reserved. 

 
/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import SwiftUI

struct ActivityIndicator: View {
    @State private var isAnimating: Bool = false
    
    private let dotSize = 0.1
    private let dotsCount = 6

    var body: some View {
        GeometryReader { (geometry: GeometryProxy) in
            let width = geometry.size.width
            
            ForEach(0..<dotsCount, id: \.self) { index in
                let ratio = Double(index) / Double(dotsCount)
                let offsetY = -width / 2
                
                Circle()
                    .opacity(ratio)
                    .scaleEffect(dotSize * ratio + dotSize)
                    .offset(y: offsetY)
                    .rotationEffect(.degrees(isAnimating ? 360 : 0))
                    .animation(
                        Animation
                        .timingCurve(0.5, 0.05 + ratio, 0.3, 0.9, duration: 1.25)
                        .repeatForever(autoreverses: false),
                        value: isAnimating
                    )
            }
        }
        .opacity(isAnimating ? 1.0 : 0.0)
        .onAppear {
            enable()
        }
    }
    
    private func enable() {
        isAnimating = true
    }
}
